-- select * from hib.showdocumenttemplateworkflowtemplate order by workflowtemplateid,documenttemplateid
-- select * from hib.showdocumenttemplateworkflowtemplate where documenttemplateid in (5,7,9,13,46) order by workflowtemplateid,documenttemplateid

--; Delete all entries in the showdocumenttemplateworkflowtemplate table
Delete from hib.[showdocumenttemplateworkflowtemplate]

/*
	In addition to the documents that are required by the Independent data source:
	The independent should be able to see documents in Req. 3.9, the Research Request memo, and the Research Protocol.
		
//	Req. 3.9:  The following documents are common to all workflows and may be changed by Change Request:
//				Research Study Institutional Review Board (IRB) Approval Letter	--documenttemplateid=5
//				Sample Informed Consent and HIPAA Authorization					--documenttemplateid=7
//				Research and Development (RD) Committee Approval Letter			--documenttemplateid=9
//				IRB Approval of Waiver of HIPAA-Compliant Authorization			--documenttemplateid=13
//				Real SSN Access Request											--documenttemplateid=46

select * from hib.documenttemplate where [name] like '%Research Request Memo%'			--documenttemplateid=4
select * from hib.documenttemplate where [name] like '%Research Protocol%'				--documenttemplateid=18

--common documents
select * from hib.documenttemplate where [name] like '%Research Study Institutional Review Board (IRB) Approval Letter%'	--documenttemplateid=5
select * from hib.documenttemplate where [name] like '%Sample Informed Consent and HIPAA Authorization%'					--documenttemplateid=7
select * from hib.documenttemplate where [name] like '%Research and Development (RD) Committee Approval Letter%'			--documenttemplateid=9
select * from hib.documenttemplate where [name] like '%IRB Approval of Waiver of HIPAA-Compliant Authorization%'			--documenttemplateid=13
select * from hib.documenttemplate where [name] like '%Real SSN Access Request%'											--documenttemplateid=46
*/


--common documents (OEF/OIF Workflow)
Insert into hib.[showdocumenttemplateworkflowtemplate] (documenttemplateid, workflowtemplateid)
values (5,3)
Insert into hib.[showdocumenttemplateworkflowtemplate] (documenttemplateid, workflowtemplateid)
values (7,3)
Insert into hib.[showdocumenttemplateworkflowtemplate] (documenttemplateid, workflowtemplateid)
values (9,3)
Insert into hib.[showdocumenttemplateworkflowtemplate] (documenttemplateid, workflowtemplateid)
values (13,3)

--Research Request memo, and the Research Protocol (OEF/OIF Workflow)
Insert into hib.[showdocumenttemplateworkflowtemplate] (documenttemplateid, workflowtemplateid)
values (4,3)
Insert into hib.[showdocumenttemplateworkflowtemplate] (documenttemplateid, workflowtemplateid)
values (18,3)


-------------------------------------------------------------------------------------------------
--common documents (SQDUG Workflow)
Insert into hib.[showdocumenttemplateworkflowtemplate] (documenttemplateid, workflowtemplateid)
values (5,2)
Insert into hib.[showdocumenttemplateworkflowtemplate] (documenttemplateid, workflowtemplateid)
values (7,2)
Insert into hib.[showdocumenttemplateworkflowtemplate] (documenttemplateid, workflowtemplateid)
values (9,2)
Insert into hib.[showdocumenttemplateworkflowtemplate] (documenttemplateid, workflowtemplateid)
values (13,2)

--Research Request memo, and the Research Protocol (SQDUG Workflow)
Insert into hib.[showdocumenttemplateworkflowtemplate] (documenttemplateid, workflowtemplateid)
values (4,2)
Insert into hib.[showdocumenttemplateworkflowtemplate] (documenttemplateid, workflowtemplateid)
values (18,2)
